#ifdef GL_ES
attribute vec3 inVertex;
attribute vec2 inTexCoord0;

varying vec2 vTexCoord;
varying vec4 shadowCoord;
#else
in vec3 inVertex;
in vec2 inTexCoord0;

out vec2 vTexCoord;
out vec4 shadowCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 shadowMatrix;

void main()
{
	vTexCoord = inTexCoord0;
	
	vec4 fourInVertex = vec4(inVertex, 1.0);
	shadowCoord = shadowMatrix * fourInVertex;

	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
